/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.item;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.item.IItemCanteen;
import com.charles445.simpledifficulty.api.thirst.IThirstCapability;
import com.charles445.simpledifficulty.api.thirst.ThirstEnum;
import com.charles445.simpledifficulty.api.thirst.ThirstEnumBlockPos;
import com.charles445.simpledifficulty.api.thirst.ThirstUtil;
import com.charles445.simpledifficulty.config.json.ExtraItem;
import com.charles445.simpledifficulty.item.ItemCanteen;
import com.charles445.simpledifficulty.util.SoundUtil;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDragonCanteen
extends ItemCanteen {
    public static final String EI_CAPACITY = "capacity";
    public int capacity = 5;

    public ItemDragonCanteen(ExtraItem extraItem) {
        Integer oCapacity = extraItem.getInteger(EI_CAPACITY);
        if (oCapacity != null) {
            this.capacity = oCapacity;
        }
        this.func_185043_a(new ResourceLocation("contain"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                IItemCanteen canteen;
                if (stack.func_77973_b() instanceof IItemCanteen && !(canteen = (IItemCanteen)stack.func_77973_b()).isCanteenEmpty(stack)) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    @Override
    public int getMaxDoses(ItemStack stack) {
        return this.capacity;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        if (this.isCanteenEmpty(stack)) {
            return "item.simpledifficulty:dragon_canteen_empty";
        }
        int type = this.getTypeTag(stack).func_150287_d();
        if (type >= ThirstEnum.values().length) {
            return "item.simpledifficulty:dragon_canteen_broken";
        }
        return "item.simpledifficulty:dragon_canteen_" + ThirstEnum.values()[type].toString();
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack emptyCanteen = new ItemStack((Item)this, 1, 0);
            this.tryAddDose(emptyCanteen, ThirstEnum.PURIFIED);
            this.setCanteenEmpty(emptyCanteen);
            ItemStack fullCanteen = emptyCanteen.func_77946_l();
            this.tryAddDose(fullCanteen, ThirstEnum.PURIFIED);
            this.setCanteenFull(fullCanteen);
            this.customSetTypeTag(emptyCanteen);
            this.customSetTypeTag(fullCanteen);
            items.add((Object)emptyCanteen);
            items.add((Object)fullCanteen);
        }
    }

    @Override
    @Nullable
    public ThirstEnum getThirstEnum(ItemStack stack) {
        return ThirstEnum.PURIFIED;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        IThirstCapability capability;
        ThirstEnumBlockPos traceBlockPos;
        ItemStack stack = player.func_184586_b(hand);
        if (!this.isCanteenFull(stack) && (traceBlockPos = ThirstUtil.traceWater(player)) != null) {
            ThirstEnum trace = traceBlockPos.thirstEnum;
            if (trace == ThirstEnum.PURIFIED) {
                player.field_70170_p.func_175698_g(traceBlockPos.pos);
            }
            this.tryAddDose(stack, ThirstEnum.PURIFIED);
            SoundUtil.commonPlayPlayerSound(player, SoundEvents.field_187630_M);
            player.func_184598_c(hand);
            player.func_184609_a(hand);
            player.func_184597_cx();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!(this.isCanteenEmpty(stack) || !(capability = SDCapabilities.getThirstData(player)).isThirsty() && QuickConfig.isThirstEnabled())) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    protected void customSetTypeTag(ItemStack stack) {
        stack.func_77983_a("CanteenType", (NBTBase)new NBTTagInt(ThirstEnum.PURIFIED.ordinal()));
    }
}

